<?php 
/**
 * Bilgi Kutuları Bileşeni.
 */
class TemaVadisi_bilgi_kutusu extends WP_Widget {

	function __construct() 
{
		parent::__construct(
			'bilgikutusu',
			'(VADİ) Bilgi Kutusu',
			array( 
			'description' => 'Bilgi kutularını gösteren bileşendir.',
			)
		);
}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
?>
<div class="bilgikutulari">
<?php
	$bilgikutulari = cs_get_option('bilgikutulari');
	if($bilgikutulari) {
		foreach($bilgikutulari as $kutu) {
			echo '<div class="bilgikutu" style="background:'.$kutu['kuturenk'].';">';
				echo '<i class="bicon '.$kutu['kutuicon'].'"></i>';
				echo '<div class="bcont"><h4>'.$kutu['kutubas'].'</h4><p>'.$kutu['kutuaciklama'].'</p></div>';
			echo '</div>';
		}
	}
?>
<div class="clear"></div>
</div>
<?php
		echo $args['after_widget'];
	}

	public function form( $instance ) {

		echo '<p>Bu bileşenin ayarları tema panelinden yapılmaktadır.</p>';

	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();

		return $instance;
	}

} 


function register_bilgi_kutusu() {
    register_widget( 'TemaVadisi_bilgi_kutusu' );
}
add_action( 'widgets_init', 'register_bilgi_kutusu' );
?>