<?php 
/**
 * Blog Yazıları Bileşeni.
 */
class TemaVadisi_blog_yazilari extends WP_Widget {

	function __construct() 
{
		parent::__construct(
			'blogyazilari',
			'(VADİ) Blog Yazıları',
			array( 
			'description' => 'Belirlediğiniz kategorilere ait yazıları gösterebileceğiniz bileşendir.',
			)
		);
}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$baslikbg = $instance['baslikbg'];
		$baslikcl = $instance['baslikcl'];
?>
<div class="blog_yazilari">
<?php if($instance['baslikbg']) { ?>
<style>
	.<?php echo $args['widget_id']; ?> .yanbaslik:before{background:<?php echo $instance['baslikbg']; ?> !important;}
	.<?php echo $args['widget_id']; ?> .yanbaslik{color:<?php echo $instance['baslikcl']; ?> !important;}
</style>
<?php } ?>
<div class="section group">
<?php 
	if(!empty($instance['kategori'])) {
	$kategoriler = implode(",", $instance['kategori']);
	} else {
	$kategoriler = '-1';	
	}
	$catargs = array (
	'order' => 'desc',
	'cat' => $kategoriler,
	'showposts' => $instance['showposts'],
	);

	$kategoripost = new WP_Query($catargs);
        if( $kategoripost->have_posts() ) {
			while ($kategoripost->have_posts()) : $kategoripost->the_post();
?>
<article class="blog_yazi col span4" itemscope itemtype="http://schema.org/Article">
<div class="postimg">
	<a href="<?php the_permalink(); ?>">
		<?php echo TemaVadisi_onresim('galerisize', 364, 300, ''); ?>
		<i class="icon-link"></i>
	</a>
</div>
<div class="post-wrap">
	<h2 class="post-title" itemprop="name">
		<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
	</h2>
	<div class="devami button">
		<a href="<?php the_permalink(); ?>" rel="bookmark"><?php echo __('Devamını oku <i class="icon-right-thin"></i>', 'temavadisi'); ?></a>
	</div>
</div>
</article>
<?php
			endwhile; wp_reset_query();
		}
 ?>
 </div>
<div class="clear"></div>
</div>
<?php
		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$title = !empty( $instance['title'] ) ? $instance['title'] : '';
		$kategori = !empty( $instance['kategori'] ) ? $instance['kategori'] : '';
		$showposts = !empty( $instance['showposts'] ) ? $instance['showposts'] : '3';
		$baslikbg = !empty( $instance['baslikbg'] ) ? $instance['baslikbg'] : '#dd3355';
		$baslikcl = !empty( $instance['baslikcl'] ) ? $instance['baslikcl'] : '#fff';

	echo '<h2 style="padding-bottom:10px;border-bottom:1px solid #eaeaea;">Bileşen Ayarları</h2>';


	// Text Element
	$title_field = array(
		'type'  => 'text',
		'id'    => $this->get_field_id('title'),
		'name'  => $this->get_field_name('title'),
		'title' => 'Başlık',
		'attributes'    => array(
		'placeholder' => 'Başlık yazınız',
		),
		);
	echo cs_add_element( $title_field, $title );
	
	// Select Element
	$select_field = array(
		'type'  => 'select',
		'id'    => $this->get_field_id('kategori'),
		'name'  => $this->get_field_name('kategori'),
		'title' => 'Gösterilecek Kategoriler',
		'options'  => 'categories',
		'class' => 'chosen',
		'attributes'    => array(
		'data-placeholder' => 'Gösterilecek Kategoriler',
		'multiple' => 'only-key',
        'style' => 'width: 200px;'
		),
		);
	echo cs_add_element( $select_field, $kategori );


	// Number Element
	$number_field = array(
		'type'  => 'number',
		'id'    => $this->get_field_id('showposts'),
		'name'  => $this->get_field_name('showposts'),
		'title' => 'Gösterilecek Yazı Sayısı',
		'after'   => ' <i class="cs-text-muted">(adet yazı.)</i>',
		);
	echo cs_add_element( $number_field, $showposts );	
	
	// Color Element
	$color_field =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikbg'),
		'name'  => $this->get_field_name('baslikbg'),
      'title'   => 'Arkaplan Rengi',
      'desc' => 'Arkaplan rengini seçin.',
	  'default'	=> '#dd3355',
    );
	echo cs_add_element( $color_field, $baslikbg );
	
	// Color Element
	$color_field2 =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikcl'),
		'name'  => $this->get_field_name('baslikcl'),
      'title'   => 'Metin Rengi',
      'desc' => 'Metin rengini seçin.',
	  'default'	=> '#fff',
    );
	echo cs_add_element( $color_field2, $baslikcl );
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['kategori'] = $new_instance['kategori'];
		$instance['showposts'] = ( !empty( $new_instance['showposts'] ) ) ? strip_tags( $new_instance['showposts'] ) : '';
		$instance['baslikbg']		= ( !empty( $new_instance['baslikbg'] ) ) ? $new_instance['baslikbg'] : '';
		$instance['baslikcl']		= ( !empty( $new_instance['baslikcl'] ) ) ? $new_instance['baslikcl'] : '';

		return $instance;
	}

} 


function register_blog_yazilari() {
    register_widget( 'TemaVadisi_blog_yazilari' );
}
add_action( 'widgets_init', 'register_blog_yazilari' );
?>