<?php 
/**
 * Galeri Bileşeni.
 */
class TemaVadisi_galeri extends WP_Widget {

	function __construct() 
{
		parent::__construct(
			'galeriwidget',
			'(VADİ) Galeri',
			array( 
			'description' => 'Resim galerisi gösteren bileşendir.',
			)
		);
}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$baslikbg = $instance['baslikbg'];
		$baslikcl = $instance['baslikcl'];
?>
<div class="galeriwidget">
<?php if($instance['baslikbg']) { ?>
<style>
	.<?php echo $args['widget_id']; ?> .yanbaslik:before{background:<?php echo $instance['baslikbg']; ?> !important;}
	.<?php echo $args['widget_id']; ?> .yanbaslik{color:<?php echo $instance['baslikcl']; ?> !important;}
</style>
<?php } ?>
<div class="widgetresimler magnify">
<?php
	if($instance['galeri']) {
		$resimIDler = explode( ',', $instance['galeri'] );
		foreach($resimIDler as $ids) {
			echo '<div class="galeriresim">';
				echo wp_get_attachment_link($ids, 'galerisize');
			echo '</div>';
		}
	}
?>
</div>
</div>
<?php
		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$title = !empty( $instance['title'] ) ? $instance['title'] : '';
		$galeri = !empty( $instance['galeri'] ) ? $instance['galeri'] : '';
		$baslikbg = !empty( $instance['baslikbg'] ) ? $instance['baslikbg'] : '#dd3355';
		$baslikcl = !empty( $instance['baslikcl'] ) ? $instance['baslikcl'] : '#fff';
		
		echo '<h2 style="padding-bottom:10px;border-bottom:1px solid #eaeaea;">Bileşen Ayarları</h2>';
		
	$title_field = array(
		'type'  => 'text',
		'id'    => $this->get_field_id('title'),
		'name'  => $this->get_field_name('title'),
		'title' => 'Başlık',
		'attributes'    => array(
		'placeholder' => 'Başlık (opsiyonel)',
		),
		);
	echo cs_add_element( $title_field, $title );

	$galeri_field = array(
		'type'  => 'gallery',
		'id'    => $this->get_field_id('galeri'),
		'name'  => $this->get_field_name('galeri'),
		'title' => 'Galeri Resimleri',
		);
	echo cs_add_element( $galeri_field, $galeri );
	
	// Color Element
	$color_field =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikbg'),
		'name'  => $this->get_field_name('baslikbg'),
      'title'   => 'Arkaplan Rengi',
      'desc' => 'Arkaplan rengini seçin.',
	  'default'	=> '#dd3355',
    );
	echo cs_add_element( $color_field, $baslikbg );
	
	// Color Element
	$color_field2 =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikcl'),
		'name'  => $this->get_field_name('baslikcl'),
      'title'   => 'Metin Rengi',
      'desc' => 'Metin rengini seçin.',
	  'default'	=> '#fff',
    );
	echo cs_add_element( $color_field2, $baslikcl );

	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['galeri'] = ( !empty( $new_instance['galeri'] ) ) ? strip_tags( $new_instance['galeri'] ) : '';
		$instance['baslikbg']		= ( !empty( $new_instance['baslikbg'] ) ) ? $new_instance['baslikbg'] : '';
		$instance['baslikcl']		= ( !empty( $new_instance['baslikcl'] ) ) ? $new_instance['baslikcl'] : '';

		return $instance;
	}

} 


function register_galeri() {
    register_widget( 'TemaVadisi_galeri' );
}
add_action( 'widgets_init', 'register_galeri' );
?>