<?php 
/**
 * Musteri Yorumlari Bileşeni.
 */
class TemaVadisi_musteriyorumlari extends WP_Widget {

	function __construct() 
{
		parent::__construct(
			'musteriyorumlariwidget',
			'(VADİ) Müşteri Yorumları',
			array( 
			'description' => 'Müşteri yorumlarını gösteren bileşendir.',
			)
		);
}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$baslikbg = $instance['baslikbg'];
		$baslikcl = $instance['baslikcl'];
?>
<div class="musteriyorumlari">
<?php if($instance['baslikbg']) { ?>
<style>
	.<?php echo $args['widget_id']; ?> .yanbaslik:before{background:<?php echo $instance['baslikbg']; ?> !important;}
	.<?php echo $args['widget_id']; ?> .yanbaslik{color:<?php echo $instance['baslikcl']; ?> !important;}
</style>
<?php } ?>
<div class="yorum-sitem">
<?php 
	$mustericount = $instance['mustericount'];
	$yorum_query = new WP_Query( 'post_type=musteriyorumlari&posts_per_page='.$mustericount.'' ); 
	if ( $yorum_query->have_posts() ) : while ( $yorum_query->have_posts() ) : $yorum_query->the_post(); 
?>
<div class="yorum-item">
	<div class="musteri_meta">
		<img src="<?php echo TemaVadisi_onresimurl(); ?>" alt="<?php the_title(); ?>" class="yorum-image" />
	</div>
</div>
<?php 
	endwhile; wp_reset_query();
	echo '</div><div class="yorum-fitem">';
while ( $yorum_query->have_posts() ) : $yorum_query->the_post(); 
?>
<div class="yorum-item">
	<div class="yorum-text">
		<span class="yorum-desc"><?php the_content(); ?></span>
		<div class="musteriadi"><?php the_title(); ?></div>
	</div>
</div>

<?php 
	endwhile; wp_reset_query();
	else: endif;
?>
</div>
</div>
<?php
		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$title = !empty( $instance['title'] ) ? $instance['title'] : '';
		$mustericount = !empty( $instance['mustericount'] ) ? $instance['mustericount'] : '10';
		$baslikbg = !empty( $instance['baslikbg'] ) ? $instance['baslikbg'] : '#dd3355';
		$baslikcl = !empty( $instance['baslikcl'] ) ? $instance['baslikcl'] : '#fff';
		
		echo '<h2 style="padding-bottom:10px;border-bottom:1px solid #eaeaea;">Bileşen Ayarları</h2>';

	$title_field = array(
		'type'  => 'text',
		'id'    => $this->get_field_id('title'),
		'name'  => $this->get_field_name('title'),
		'title' => 'Başlık',
		'attributes'    => array(
		'placeholder' => 'Başlık (opsiyonel)',
		),
		);
	echo cs_add_element( $title_field, $title );

	$mustericount_field = array(
		'type'  => 'number',
		'id'    => $this->get_field_id('mustericount'),
		'name'  => $this->get_field_name('mustericount'),
		'title' => 'Gösterilecek Sayı',
		'after'   => ' <i class="cs-text-muted">(adet yorum gösterilecektir.)</i>',
		);
	echo cs_add_element( $mustericount_field, $mustericount );
	
	// Color Element
	$color_field =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikbg'),
		'name'  => $this->get_field_name('baslikbg'),
      'title'   => 'Arkaplan Rengi',
      'desc' => 'Arkaplan rengini seçin.',
	  'default'	=> '#dd3355',
    );
	echo cs_add_element( $color_field, $baslikbg );
	
	// Color Element
	$color_field2 =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikcl'),
		'name'  => $this->get_field_name('baslikcl'),
      'title'   => 'Metin Rengi',
      'desc' => 'Metin rengini seçin.',
	  'default'	=> '#fff',
    );
	echo cs_add_element( $color_field2, $baslikcl );

	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['mustericount'] = ( !empty( $new_instance['mustericount'] ) ) ? strip_tags( $new_instance['mustericount'] ) : '';
		$instance['baslikbg']		= ( !empty( $new_instance['baslikbg'] ) ) ? $new_instance['baslikbg'] : '';
		$instance['baslikcl']		= ( !empty( $new_instance['baslikcl'] ) ) ? $new_instance['baslikcl'] : '';

		return $instance;
	}

} 


function register_musteriyorumlari() {
    register_widget( 'TemaVadisi_musteriyorumlari' );
}
add_action( 'widgets_init', 'register_musteriyorumlari' );
?>