<?php

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

/**
 * Resim Açıklama Bileşeni.
**/

class TemaVadisi_resim_aciklama extends WP_Widget {

	public function __construct() {
		$widget_name = esc_html__( '(VADİ) Resim Açıklama', 'temavadisi' );

		$widget_ops = apply_filters(
			'resimwidget',
			array(
				'classname' 	=> 'TemaVadisi_resim_aciklama',
				'description' 	=> __( 'Resim ve açıklama ekleyebileceğiniz bileşendir.', 'temavadisi' ),
			)
		);
		
		parent::__construct(
			'TemaVadisi_resim_aciklama',
			$widget_name,
			$widget_ops
		);

	}

	public function widget( $args, $instance ) {

		$aciklama		= apply_filters( 'wp_editor_widget_content', $instance['aciklama'] );
		$baslikbg = $instance['baslikbg'];
		$baslikcl = $instance['baslikcl'];
		
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'wp_editor_widget_title', $instance['title'] ) . $args['after_title'];
		}
		
		$show = true;
		
		if ( $show ) {

		$default_html .= $aciklama;
?>
<div class="resim_aciklama">
<?php if($instance['baslikbg']) { ?>
<style>
	.<?php echo $args['widget_id']; ?> .yanbaslik:before{background:<?php echo $instance['baslikbg']; ?> !important;}
	.<?php echo $args['widget_id']; ?> .yanbaslik{color:<?php echo $instance['baslikcl']; ?> !important;}
</style>
<?php } ?>
<div class="section group">
	<div class="col span6 resim">
		<img src="<?php echo $instance['img']; ?>" alt="<?php echo $instance['title']; ?>" />
	</div>
	<div class="col span6 aciklama">
		<?php echo apply_filters( 'wp_editor_widget_html', $default_html, $args['id'], $instance, $args['before_widget'], $args['after_widget'], $title, $args['before_title'], $args['after_title'], $aciklama ); ?>
	</div>
</div>
</div>
<?php
		}

	echo $args['after_widget'];

	}

	public function form( $instance ) {

		$title = !empty( $instance['title'] ) ? $instance['title'] : '';
		$img = !empty( $instance['img'] ) ? $instance['img'] : '';
		$aciklama = !empty( $instance['aciklama'] ) ? $instance['aciklama'] : '';
		$baslikbg = !empty( $instance['baslikbg'] ) ? $instance['baslikbg'] : '#dd3355';
		$baslikcl = !empty( $instance['baslikcl'] ) ? $instance['baslikcl'] : '#fff';
		
		echo '<h2 style="padding-bottom:10px;border-bottom:1px solid #eaeaea;">Bileşen Ayarları</h2>';
?>
		<input type="hidden" id="<?php echo esc_attr( $this->get_field_id( 'aciklama' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'aciklama' ) ); ?>" value="<?php echo esc_attr( $aciklama ); ?>">
<?php 
	// Text Element
	$title_field = array(
		'type'  => 'text',
		'id'    => $this->get_field_id('title'),
		'name'  => $this->get_field_name('title'),
		'title' => 'Başlık',
		'attributes'    => array(
		'placeholder' => 'Başlık yazınız',
		),
		);
	echo cs_add_element( $title_field, $title );

	// Upload Element
	$img_field = array(
		'type'  => 'upload',
		'id'    => $this->get_field_id('img'),
		'name'  => $this->get_field_name('img'),
		'title' => 'Resim',
		);
	echo cs_add_element( $img_field, $img );
?>
		<p>
			<a href="javascript:WPEditorWidget.showEditor('<?php echo esc_attr( $this->get_field_id( 'aciklama' ) ); ?>');" class="button"><?php _e( 'Açıklama girin', 'temavadisi' ) ?></a>
		</p>
<?php
		do_action( 'wp_editor_widget_form', $this, $instance );

	// Color Element
	$color_field =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikbg'),
		'name'  => $this->get_field_name('baslikbg'),
      'title'   => 'Arkaplan Rengi',
      'desc' => 'Arkaplan rengini seçin.',
	  'default'	=> '#dd3355',
    );
	echo cs_add_element( $color_field, $baslikbg );
	
	// Color Element
	$color_field2 =    array(
      'type'    => 'color_picker',
      'id'      => $this->get_field_id('baslikcl'),
		'name'  => $this->get_field_name('baslikcl'),
      'title'   => 'Metin Rengi',
      'desc' => 'Metin rengini seçin.',
	  'default'	=> '#fff',
    );
	echo cs_add_element( $color_field2, $baslikcl );

	}

	public function update( $new_instance, $old_instance ) {

		$instance = array();

		$instance['title']			= ( ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '' );
		$instance['img']			= ( ! empty( $new_instance['img'] ) ? $new_instance['img'] : '' );
		$instance['aciklama']		= ( ! empty( $new_instance['aciklama'] ) ? $new_instance['aciklama'] : '' );
		$instance['baslikbg']		= ( !empty( $new_instance['baslikbg'] ) ) ? $new_instance['baslikbg'] : '';
		$instance['baslikcl']		= ( !empty( $new_instance['baslikcl'] ) ) ? $new_instance['baslikcl'] : '';

		do_action( 'wp_editor_widget_update', $new_instance, $instance );

 	 	return apply_filters( 'wp_editor_widget_update_instance', $instance, $new_instance );

	}

}