<?php 
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

include 'resim-aciklama.php';
include 'video-aciklama.php';
include 'siparis-formu.php';

class WPEditorWidget {

	const VERSION = '0.6.0';

	public function __construct() {

		add_action( 'widgets_init', array( $this, 'widgets_init' ) );
		add_action( 'load-widgets.php', array( $this, 'load_admin_assets' ) );
		add_action( 'load-customize.php', array( $this, 'load_admin_assets' ) );
		add_action( 'widgets_admin_page', array( $this, 'output_wp_editor_widget_html' ), 100 );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'output_wp_editor_widget_html' ), 1 );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'customize_controls_print_footer_scripts' ), 2 );
		
		add_filter( 'wp_editor_widget_content', 'wptexturize' );
		add_filter( 'wp_editor_widget_content', 'convert_smilies' );
		add_filter( 'wp_editor_widget_content', 'convert_chars' );
		add_filter( 'wp_editor_widget_content', 'wpautop' );
		add_filter( 'wp_editor_widget_content', 'shortcode_unautop' );
		add_filter( 'wp_editor_widget_content', 'do_shortcode', 11 );

	}

	public function load_admin_assets() {

		wp_register_script( 'wp-editor-widget-js', get_template_directory_uri().'/inc/bilesenler/wp-editor-widget/assets/js/admin.js', array( 'jquery' ), self::VERSION );
		wp_enqueue_script( 'wp-editor-widget-js' );

		wp_register_style( 'wp-editor-widget-css', get_template_directory_uri().'/inc/bilesenler/wp-editor-widget/assets/css/admin.css', array(), self::VERSION );
		wp_enqueue_style( 'wp-editor-widget-css' );

	}

	public function output_wp_editor_widget_html() {
		
		?>
		<div id="wp-editor-widget-container" style="display: none;">
			<a class="close" href="javascript:WPEditorWidget.hideEditor();" title="<?php esc_attr_e( 'Kapat', 'temavadisi' ); ?>"><span class="icon-cancel-2"></span></a>
			<div class="editor">
				<?php
				$settings = array(
					'editor_height' => 300,
					'media_buttons' => false
				);
				wp_editor( '', 'wpeditorwidget', $settings );
				?>
				<p>
					<a href="javascript:WPEditorWidget.updateWidgetAndCloseEditor(true);" class="button button-primary"><?php _e( 'Kaydet ve kapat', 'temavadisi' ); ?></a>
				</p>
			</div>
		</div>
		<div id="wp-editor-widget-backdrop" style="display: none;"></div>
		<?php
		
	}

	public function customize_controls_print_footer_scripts() {

		$wp_version = get_bloginfo( 'version' );
		if ( version_compare( $wp_version, '3.9.1', '<' ) && class_exists( '_WP_Editors' ) ) {
			_WP_Editors::enqueue_scripts();
		}
		
	}

	public function widgets_init() {

		register_widget( 'TemaVadisi_resim_aciklama' );
		register_widget( 'TemaVadisi_video_aciklama' );
		register_widget( 'TemaVadisi_siparis_formu' );

	}

}

global $wp_editor_widget;
$wp_editor_widget = new WPEditorWidget;
