<?php 
function musteri_yorumlari() {

	$bolumler = array(
		'name'                => __( 'Müşteri Yorumları', 'Müşteri Yorumları', 'temavadisi' ),
		'singular_name'       => __( 'Müşteri Yorumları', 'Müşteri Yorumları', 'temavadisi' ),
		'menu_name'           => __( 'Müşteri Yorumları', 'temavadisi' ),
		'parent_item_colon'   => __( 'Birincil Yorum:', 'temavadisi' ),
		'all_items'           => __( 'Tüm Yorumlar', 'temavadisi' ),
		'view_item'           => __( 'Yorum Görüntüle', 'temavadisi' ),
		'add_new_item'        => __( 'Yeni Yorum Ekle', 'temavadisi' ),
		'add_new'             => __( 'Yeni Yorum', 'temavadisi' ),
		'edit_item'           => __( 'Yorum Düzenle', 'temavadisi' ),
		'update_item'         => __( 'Yorum Güncelle', 'temavadisi' ),
		'search_items'        => __( 'Yorum ara', 'temavadisi' ),
		'not_found'           => __( 'Yorum bulunamadı', 'temavadisi' ),
		'not_found_in_trash'  => __( 'Bulunamadı', 'temavadisi' ),
	);
	$ozellikler = array(
		'label'               => __( 'musteriyorumlari', 'temavadisi' ),
		'description'         => __( 'Müşteri yorumunu buradan girebilirsiniz', 'temavadisi' ),
		'labels'              => $bolumler,
		'supports'            => array( 'title', 'thumbnail', 'custom-fields', 'editor' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 54,
		'menu_icon'           => 'dashicons-format-status',
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'page',
	);
	register_post_type( 'musteriyorumlari', $ozellikler );

}
add_action( 'init', 'musteri_yorumlari');

add_filter('enter_title_here', 'musteri_yorum_basligi' , 20 , 2 );
    function musteri_yorum_basligi($title , $post){

        if( $post->post_type == 'musteriyorumlari' ){
            $musteri_adi = "Müşteri Adını Buraya Yazınız";
            return $musteri_adi;
        }

        return $title;

}

add_action('do_meta_boxes', 'musteri_resmi_title');
function musteri_resmi_title($post_type) {
    remove_meta_box( 'postimagediv', 'musteriyorumlari', 'side' );
	add_meta_box('postimagediv', 'Müşteri Resmi (120x120)', 'post_thumbnail_meta_box', 'musteriyorumlari', 'side', 'low' );
}
?>