<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// PANEL AYARLARI
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => 'Tema Ayarları',
  'menu_type'       => 'menu', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'temavadisi-panel',
  'ajax_save'       => false,
  'show_reset_all'  => false,
  'menu_position'		=> 53,
  'menu_icon'       => get_template_directory_uri().("/inc/temapanel/assets/images/").'icon-28x28.png',
  'framework_title' => '<img src="'.get_template_directory_uri().("/inc/temapanel/assets/images/").'temavadisi_logo.png" />',
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// TEMA AYARLARI
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

// ----------------------------------------
// Genel Ayarlar                          -
// ----------------------------------------
$options[]      = array(
  'name'        => 'genel-ayarlar',
  'title'       => 'Genel Ayarlar',
  'icon'        => 'icon-home',

  // basla: genel-ayarlar
  'fields'      => array(

    array(
      'id'      => 'logo',
      'type'    => 'upload',
      'title'   => 'Logo',
      'desc'    => 'Lütfen logo resim dosyanızı buradan yükleyiniz.(Boyut:300x80)',
      'default' => get_theme_file_uri( '/img/temavlogo.png' ),
    ),

    array(
      'id'      => 'favicon',
      'type'    => 'upload',
      'title'   => 'Favicon',
      'desc'    => 'Lütfen favicon resim dosyanızı buradan yükleyiniz.(Boyut:16x16)',
      'default' => get_theme_file_uri( '/img/favicon.ico' ),
    ),
	
	array(
	  'id'            => 'siparisurl',
	  'type'          => 'text',
	  'title'         => 'Sipariş URL',
	  'attributes' => array(
		'placeholder'   => 'http://',
	  ),
	),
	
	array(
	  'id'            => 'telefon',
	  'type'          => 'text',
	  'title'         => 'Telefon',
	  'attributes' => array(
		'placeholder'   => '(212) 444 44 44',
	  ),
	),
	
	  	array(
	  'id'            => 'whatsapp',
	  'type'          => 'text',
	  'title'         => 'Whatsapp',
	  'attributes' => array(
		'placeholder'   => '90(212) 444 44 44',
	  ),
	),
	array(
      'id'      => 'slidecount',
      'type'    => 'number',
      'title'   => 'Slide Sayısı',
      'after'   => ' <i class="cs-text-muted">(adet slide gösterilecektir.)</i>',
      'default' => '8',
    ),
   
    array(
      'id'                 => 'araform',
      'type'               => 'select',
      'title'              => 'Sizi Arayalım Formu',
	  'desc'			   => 'İletişim eklentisi ile oluşturduğunuz ilgili formunu seçiniz.',
	  'default_option'	   => 'Form Seçiniz',
      'options'            => 'posts',
	  'query_args'  => array(
			'post_type' => 'wpcf7_contact_form',
		),
      'class'              => 'chosen',
      'attributes'         => array(
        'style'            => 'width: 200px;'
      ),
    ),
   
    array(
      'id'                 => 'siparisform',
      'type'               => 'select',
      'title'              => 'Sipariş Formu',
	  'desc'			   => 'İletişim eklentisi ile oluşturduğunuz ilgili formunu seçiniz.',
	  'default_option'	   => 'Form Seçiniz',
      'options'            => 'posts',
	  'query_args'  => array(
			'post_type' => 'wpcf7_contact_form',
		),
      'class'              => 'chosen',
      'attributes'         => array(
        'style'            => 'width: 200px;'
      ),
    ),
	
    array(
      'id'       => 'copyright',
      'type'     => 'wysiwyg',
      'title'    => 'Copyright',
      'after'     => '<i class="cs-text-muted">Sitenin en alt kısmında gösterilecek metni yazınız.</i>',
      'default'     => '&copy; '.get_the_date('Y', true).' '.get_bloginfo('name').' - Temavadisi.com',	  
      'settings' => array(
         'textarea_rows' => 5,
         'tinymce'       => true,
         'media_buttons' => false,
      )
   ),

  ), // bitir: genel-ayarlar
);


// ------------------------------
// Font Ayarları                -
// ------------------------------

$options[]   = array(
  'name'     => 'font-ayarlari',
  'title'    => 'Font Ayarları',
  'icon'     => 'icon-font',
    // basla: font-ayarları
  'fields'   => array(

   array(
      'id'        => 'headfont',
      'type'      => 'typography',
      'title'     => 'Başlık Fontları',
      'help'	  => 'Site genelinde h1,h2,h3,h4,h5,h6,a etiketlerinin kullanacağı font tipini seçiniz.(Seçtiğiniz yazı tipi Türkçe destekli olmalıdır.)',
      'default'   => array(
        'family'  => 'Raleway',
        'font'    => 'google',
      ),
	  'variant'   => false,
		'size'	  => false,
		'height'	  => false,
		'color'	  => false,
		'preview' => true,
		'preview_text' => 'Seçeceğiniz fontun önizlemesini buradan yapabilirsiniz.Seçtiğiniz font ailesinin Türkçe karakter desteklediğinden emin olunuz.',
      ),

   array(
      'id'        => 'textfont',
	  'type'      => 'typography',
	  'title'     => 'Metin Fontları',
	  'help'	  => 'Site genelindeki metinlerde kullanılacak font tipini seçiniz.(Seçtiğiniz yazı tipi Türkçe destekli olmalıdır.)',
	  'default'   => array(
      	'family'  => 'Open Sans',
        'font'    => 'google',
		'size'	  => '16',
       ),
	  'variant'   => false,
	  'size'	  => true,
	  'height'	  => false,
	  'color'	  => false,
	  'preview' => true,
	  'preview_text' => 'Seçeceğiniz fontun önizlemesini buradan yapabilirsiniz.Seçtiğiniz font ailesinin Türkçe karakter desteklediğinden emin olunuz.',
      ),

  )
    // bitir: font-ayarları
);


// ------------------------------
// Renk Ayarları                -
// ------------------------------

$options[]   = array(
  'name'     => 'renk-ayarlari',
  'title'    => 'Renk Ayarları',
  'icon'     => 'icon-adjust',
    // basla: renk-ayarları
  'fields'   => array(

   array(
      'id'      => 'anamenuback',
      'type'    => 'color_picker',
      'title'   => 'Menü Arkaplan Rengi',
      'default' => '#dd3355',
      'desc' => 'Site menü arkaplanını kapsayan alanın rengini seçin.',
    ),

   array(
      'id'      => 'menucolor',
      'type'    => 'color_picker',
      'title'   => 'Menü Link Rengi',
      'default' => '#fff',
      'desc' => 'Logo yanındaki menü bağlantılarının rengini seçin.',
    ),
	
   array(
      'id'      => 'chrome',
      'type'    => 'color_picker',
      'title'   => 'Mobil Tarayıcı Rengi',
      'default' => '#dd3355',
      'desc' => 'Mobilden chrome tarayıcı ile girişlerde gösterilecek site renginizi belirleyin.',
    ),
	
   array(
      'id'      => 'link-hover',
      'type'    => 'color_picker',
      'title'   => 'Birincil Renk',
      'default' => '#dd3355',
      'desc' => 'Site genelinde bağlantılarda vb kullanılacak ana rengi seçiniz.',
    ),
	
   array(
      'id'      => 'homebaslikback',
      'type'    => 'color_picker',
      'title'   => 'Bileşen Arkaplan Rengi',
      'default' => '#dd3355',
      'desc' => 'Site anasayfa bileşen başlıklarında kullanılacak varsayılan arkaplan rengini seçiniz.',
    ),
	
   array(
      'id'      => 'homebasliktxt',
      'type'    => 'color_picker',
      'title'   => 'Bileşen Metin Rengi',
      'default' => '#fff',
      'desc' => 'Site anasayfa bileşen başlıklarında kullanılacak varsayılan metin rengini seçiniz.',
    ),
	
   array(
      'id'      => 'footerback',
      'type'    => 'color_picker',
      'title'   => 'Footer Arkaplan',
      'default' => '#41495b',
      'desc' => 'Sitenin en altındaki alan için kullanılacak arkaplan rengini seçiniz.',
    ),
	
   array(
      'id'      => 'footerbacktxt',
      'type'    => 'color_picker',
      'title'   => 'Footer Metin Rengi',
      'default' => '#c1c2c7',
      'desc' => 'Sitenin en altındaki alan için kullanılacak metin rengini seçiniz.',
    ),

  )
    // bitir: renk-ayarları
);

// ------------------------------
// Sosyal Ağlar                 -
// ------------------------------

$options[]   = array(
  'name'     => 'sosyal-aglar',
  'title'    => 'Sosyal Ağlar',
  'icon'     => 'icon-share',
    // basla: sosyal-aglar
  'fields'   => array(

   array(
      'id'              => 'sosyalaglar',
      'type'            => 'group',
      'title'           => 'Sosyal Ağlarınız',
      'button_title'    => 'Profil ekle',
      'accordion_title' => 'Profil ekle',
      'fields'          => array(

		array(
		  'id'            => 'profilurl',
		  'type'          => 'text',
		  'title'         => 'Profil URL',
		),
		
		array(
          'id'       => 'sosyalicon',
          'type'    => 'icon',
          'title'   => 'Sosyal Ağ İconu',
        ),

	),

      ),

  )
    // bitir: sosyal-aglar
);

// ------------------------------
// Bilgi Kutuları                 -
// ------------------------------

$options[]   = array(
  'name'     => 'bilgi-kutuları',
  'title'    => 'Bilgi Kutuları',
  'icon'     => 'icon-doc-landscape',
    // basla: bilgi-kutulari
  'fields'   => array(

   array(
      'id'              => 'bilgikutulari',
      'type'            => 'group',
      'title'           => 'Bilgi Kutuları',
      'button_title'    => 'Kutu ekle',
      'accordion_title' => 'Kutu ekle',
      'fields'          => array(

		array(
		  'id'            => 'kutuicon',
		  'type'          => 'icon',
		  'title'         => 'Kutu İcon',
		),
		
		array(
          'id'       => 'kutubas',
          'type'    => 'text',
          'title'   => 'Kutu Başlık',
        ),
		
		array(
          'id'       => 'kutuaciklama',
          'type'    => 'text',
          'title'   => 'Kutu Kısa Açıklama',
        ),
		
		array(
          'id'       => 'kuturenk',
          'type'    => 'color_picker',
          'title'   => 'Kutu Renk',
		  'default' => '#dd3355',
        ),

	),

      ),

  )
    // bitir: bilgi-kutulari
);


// ------------------------------
// Kod Ayarları                -
// ------------------------------

$options[]   = array(
  'name'     => 'kod-ayarlari',
  'title'    => 'Kodlar',
  'icon'     => 'icon-terminal',
    // basla: kod-ayarlari
  'fields'   => array(

   array(
      'id'     => 'analiytics',
      'type'   => 'textarea',
      'before' => '<h4>Analytics Kodlarınız</h4>',
      'after'  => '<p class="cs-text-muted">Analytics kodlarınızı buraya ekleyebilirsiniz.</h4>',
	  'sanitize' => false,
   ),
   
   array(
      'id'     => 'headerkod',
      'type'   => 'textarea',
      'before' => '<p class="cs-text-muted"><\head> etiketinden önce ekleyeceğiniz kodları buraya ekleyebilirsiniz.</p>',
	  'sanitize' => false,
    ),

   array(
      'id'     => 'footerkod',
      'type'   => 'textarea',
      'before' => '<p class="cs-text-muted"><\body> etiketinden önce ekleyeceğiniz kodları buraya ekleyebilirsiniz.</p>',
	  'sanitize' => false,
   ),
   
   array(
      'id'      => 'tarayici_bellek',
      'type'    => 'switcher',
      'title'   => 'Tarayıcı Önbelleği',
      'label'	=> 'Bu ayarı açtıktan sonra Ayarlar -> Kalıcı bağlantılar bölümünden ayarlarınızı güncellemeniz gerekmektedir.Cache eklentisi kullanacaksanız kapalı olarak ayarlayın.',
      'on_text' => 'Açık',
      'off_text' => 'Kapalı',
      'default' => false,
   ),	
   
   array(
      'id'      => 'wp-surum',
      'type'    => 'switcher',
      'title'   => 'Wordpress Sürüm Bilgisi',
      'label'	=> 'Wordpress sürüm kodlarını kaynak kodlarından kaldırır.',
      'on_text' => 'Kaldır',
      'off_text' => 'Kaldırma',
      'default' => true,
   ),

   array(
      'id'      => 'wp-emoji',
      'type'    => 'switcher',
      'title'   => 'Emoji',
      'label'	=> 'Wordpress emoji kodlarını kaynak kodlarından kaldırır.',
      'on_text' => 'Kaldır',
      'off_text' => 'Kaldırma',
      'default' => true,
   ),
		
   array(
      'id'      => 'json-api',
      'type'    => 'switcher',
      'title'   => 'Json API',
      'label'	=> 'Json api kodlarını kaynak kodlarından kaldırır.',
      'on_text' => 'Kaldır',
      'off_text' => 'Kaldırma',
      'default' => true,
   ),

  )
    // bitir: kod-ayarlari
);


// ------------------------------
// backup                       -
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    => 'Yedekle/Geri Yükle',
  'icon'     => 'icon-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'danger',
      'content' => 'Bu alandan tema ayarlarını yedekleyip, yedeklediğiniz ayarları geri yükleyebilirsiniz.',
    ),

    array(
      'type'    => 'backup',
    ),

  )
);


// ------------------------------
// lisans                      -
// ------------------------------
$options[]   = array(
  'name'     => 'kullanim-dokumani',
  'title'    => 'Kullanım Dökümanı',
  'icon'     => 'icon-info',
  'fields'   => array(

    array(
      'type'    => 'heading',
      'content' => 'Bu tema temavadisi.com tarafından ücretli olarak satılmaktadır..'
    ),
    array(
	  'id'		=> 'kullanim_dokumani',
      'type'    => 'content',
      'content' => 'Tema kullanımı hakkında bilgi almak için <a href="http://demo.temavadisi.com/dokuman/vaditekurun" target="_blank"><strong>Kullanım Dökümanına buradan</strong></a> bakabilirsiniz. Yardım almak için lütfen <a href="https://www.temavadisi.com" target="_blank">www.temavadisi.com</a> adresindeki <strong>Destek sistemini</strong> kullanınız.',
    ),

  )
);

CSFramework::instance( $settings, $options );
