<?php
define( 'NOTIFIER_THEME_NAME', 'Vadi Tek Ürün' );
define( 'NOTIFIER_THEME_FOLDER_NAME', 'vaditekurun' );
define( 'NOTIFIER_XML_FILE', 'http://demo.temavadisi.com/dokuman/xml/vaditekurun.xml' );
define( 'NOTIFIER_CACHE_INTERVAL', 21600 ); // (21600 saniye = 6 saat)

function update_notifier_menu() {  
	if (function_exists('simplexml_load_string')) { 
	    $xml = get_latest_theme_version(NOTIFIER_CACHE_INTERVAL);
		$theme_data = wp_get_theme();
		
		if( (float)$xml->latest > (float)$theme_data['Version']) { 
			add_dashboard_page( NOTIFIER_THEME_NAME . ' Theme Updates', NOTIFIER_THEME_NAME . ' <span class="update-plugins count-1"><span class="update-count">yeni sürüm</span></span>', 'administrator', 'theme-update-notifier', 'update_notifier');
		}
	}	
}
add_action('admin_menu', 'update_notifier_menu');  

function update_notifier_bar_menu() {
	if (function_exists('simplexml_load_string')) { 
		global $wp_admin_bar, $wpdb;
	
		if ( !is_super_admin() || !is_admin_bar_showing() ) 
		return;
		
		$xml = get_latest_theme_version(NOTIFIER_CACHE_INTERVAL); 
		$theme_data = wp_get_theme(); 
	
		if( (float)$xml->latest > (float)$theme_data['Version']) { 
			$wp_admin_bar->add_menu( array( 
			'id' => 'update_notifier', 
			'title' => '<span>' . NOTIFIER_THEME_NAME . ' <span id="ab-updates">yeni sürüm mevcut</span></span>', 
			'href' => get_admin_url() . 'index.php?page=theme-update-notifier' 
			) );
		}
	}
}
add_action( 'admin_bar_menu', 'update_notifier_bar_menu', 1000 );

function update_notifier() { 
	$xml = get_latest_theme_version(NOTIFIER_CACHE_INTERVAL);
	$theme_data = wp_get_theme(); ?>
	
	<style>
		.update-nag { display: none; }
		#instructions {max-width:900px;overflow:hidden;border-bottom:1px solid #ddd;}
	</style>

	<div class="wrap">
		<div id="icon-tools" class="icon32"></div>
		<h2><?php echo NOTIFIER_THEME_NAME ?> Tema Güncellemesi</h2>
	    <div id="message" class="updated below-h2"><p><strong><?php echo NOTIFIER_THEME_NAME; ?> temasının yeni bir sürümü yayında.</strong> Kullandığınız sürüm: <?php echo $theme_data['Version']; ?>. Güncel sürüm: <?php echo $xml->latest; ?>.</p></div>
		<div id="instructions">
			<img class="alignleft" style="width:25%;margin-right:20px;" src="<?php echo get_bloginfo( 'template_url' ) . '/screenshot.png'; ?>" />
		    <h3>Güncelleme Talimatı</h3>
		    <p><strong>Dikkat:</strong> Güncelleme işlemini yapmadan önce lütfen ftp üzerinden <strong>/wp-content/themes/<?php echo NOTIFIER_THEME_FOLDER_NAME; ?>/</strong> tema dosyasının yedeğini alınız.</p>
			<p style="color:red;"><strong>Tema dosyalarınızı <a href="https://www.temavadisi.com" target="_blank">www.temavadisi.com</a> üzerinden indirebilirsiniz.</strong></p>
			<p>İndirdiğiniz temayı yükledikten sonra etkinleştirin. Sitenizi kontrol ettikten sonra sorun yoksa yedek aldığınız dosyaları silebilirsiniz.</p>
		</div>
	    
	    <h3 class="title">Değişiklikler</h3>
	    <?php echo $xml->changelog; ?>

	</div>
    
<?php } 

function get_latest_theme_version($interval) {
	$notifier_file_url = NOTIFIER_XML_FILE;	
	$db_cache_field = 'notifier-cache';
	$db_cache_field_last_updated = 'notifier-cache-last-updated';
	$last = get_option( $db_cache_field_last_updated );
	$now = time();

	if ( !$last || (( $now - $last ) > $interval) ) {

		if( function_exists('curl_init') ) { 
			$ch = curl_init($notifier_file_url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_TIMEOUT, 10);
			$cache = curl_exec($ch);
			curl_close($ch);
		} else {
			$cache = file_get_contents($notifier_file_url); 
		}
		
		if ($cache) {			

			update_option( $db_cache_field, $cache );
			update_option( $db_cache_field_last_updated, time() );
		} 

		$notifier_data = get_option( $db_cache_field );
	}
	else {

		$notifier_data = get_option( $db_cache_field );
	}

	if( strpos((string)$notifier_data, '<notifier>') === false ) {
		$notifier_data = '<?xml version="1.0" encoding="UTF-8"?><notifier><latest>1.0</latest><changelog></changelog></notifier>';
	}
	

	$xml = simplexml_load_string($notifier_data); 
	
	return $xml;
}
?>