(function() {
    var wf = document.createElement('script');
    wf.src = 'https://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
    wf.type = 'text/javascript';
    wf.async = 'true';
    var s = document.getElementsByTagName('script')[0];
    s.parentNode.insertBefore(wf, s);
  })();

$(document).on("click","a.mobnav_bar",function(){
	$(".mobil_menu").addClass("acilsin");
	return false;
});

$(document).on("click","a.mobnav_close",function(){
	$(".mobil_menu").removeClass("acilsin");
	return false;
});

$('.anaslide').on('init', function(e, slick) {
	var $firstAnimatingElements = $('div.slide-item:first-child').find('[data-animation]');
	doAnimations($firstAnimatingElements);    
});

$('.anaslide').on('beforeChange', function(e, slick, currentSlide, nextSlide) {
	var $animatingElements = $('div.slide-item[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
	doAnimations($animatingElements);    
});

$('.anaslide').slick({
	infinite: true,
	autoplay: true,
	autoplaySpeed: 5000,
	fade: true,
	prevArrow: '<i class="icon-left-open"></i>',
	nextArrow: '<i class="icon-right-open"></i>',
});

function doAnimations(elements) {
	var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
		elements.each(function() {
			var $this = $(this);
			var $animationDelay = $this.data('delay');
            var $animationType = 'animated ' + $this.data('animation');
            $this.css({
                'animation-delay': $animationDelay,
                '-webkit-animation-delay': $animationDelay
            });
    $this.addClass($animationType).one(animationEndEvents, function() {
       $this.removeClass($animationType);
    });
        });
}

$('.widgetresimler').slick({
	infinite: true,
	autoplay: true,
	autoplaySpeed: 5000,
	dots: false,
	arrows: true,
	prevArrow: '<i class="icon-left-open"></i>',
	nextArrow: '<i class="icon-right-open"></i>',
	slidesToShow: 3,
	slidesToScroll: 3,
	responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
        infinite: true,
      }
    },
    {
      breakpoint: 769,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }
  ]
});

$(document).ready(function() {
  $('.magnify a').magnificPopup({
	  type:'image',
  gallery:{
    enabled:true
  }
  });
});

$('.yorum-fitem').slick({
	slidesToShow: 1,
	slidesToScroll: 1,
	arrows: false,
	fade: true,
	asNavFor: '.yorum-sitem',
	responsive: [
    {
      breakpoint: 769,
      settings: {
		dots: true,
      }
    },
    {
      breakpoint: 480,
      settings: {
		dots: true,
      }
    }
  ]
});

$('.yorum-sitem').slick({
	slidesToShow: 5,
	slidesToScroll: 1,
	asNavFor: '.yorum-fitem',
	dots: false,
	arrows: false,
	centerMode: true,
	centerPadding: '10px',
	focusOnSelect: true,
	responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1,
        infinite: true,
      }
    },
    {
      breakpoint: 769,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
      }
    }
  ]
});